/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FiscalidadInternacional
extends ObjetoModeloSucesorValidableAnotado<PagoLocalExterior>
implements InformacionEditable<FiscalidadInternacional>,
Exportable,
Importable {
    private static final long serialVersionUID = -89617238596110130L;
    public static final String C_PAGO_LOCAL = "01";
    public static final String C_PAGO_A_NO_RESIDENTE = "02";
    public static final String C_TIPO_REGIMEN_EXTERIOR_GENERAL = "01";
    public static final String C_TIPO_REGIMEN_EXTERIOR_PARAISO = "02";
    public static final String C_TIPO_REGIMEN_EXTERIOR_DENOMINACION = "03";
    public static final String C_TIPO_REGIMEN_FISCAL_EXTERIOR = "tipoRegimenFiscalExterior";
    public static final String C_TIPO_PAGO = "tipoPago";
    public static final String C_PAIS_REGIMEN_GENERAL = "paisRegimenGeneral";
    public static final String C_PAIS_PARAISO_FISCAL = "paisParaisoFiscal";
    public static final String C_DENOMINACION_REGIMEN = "denominacionRegimen";
    public static final String C_PAIS_PAGO = "paisPago";
    private static final String SELECCIONAR_PAIS_PAGO = "Debe seleccionar el Pa\u00eds al que se Efect\u00faa el Pago";
    private String tipoRegimenFiscalExterior;
    private String descripcionTipoRegimenFiscalExterior;
    private String tipoPago;
    private String descripcionTipoPago;
    private String paisRegimenGeneral;
    private String descripcionPaisRegimenGeneral;
    private String paisParaisoFiscal;
    private String descripcionPaisParaisoFiscal;
    private String denominacionRegimen;
    private String paisPago;
    private String descripcionPaisPago;
    private boolean exportacion;

    public ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        if (this.tipoPago == null && periodo.isPeriodoDesdeEnero2013() && !this.isExportacion()) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Pago");
        }
        if (this.tipoPago != null && !"01".equals(this.getTipoPago()) && periodo.isAnexoEnPeriodoDesdeMayo2016() && StringUtil.isNullOrEmpty((String)this.getTipoRegimenFiscalExterior())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de r\u00e9gimen fiscal del exterior");
        }
        if (this.tipoPago != null && "02".equals(this.getTipoPago()) && periodo.isPeriodoDesdeEnero2013() && !this.isExportacion()) {
            return this.validarObjetosFiscalidad(periodo, resultado);
        }
        if (this.isExportacion()) {
            if (periodo.isAnexoEnPeriodoDesdeMarzo2015HastaAbril2016() && StringUtil.isNullOrEmpty((String)this.getPaisPago())) {
                return resultado.fallarValidacion("Debe seleccionar el Pa\u00eds al que se Efect\u00faa la Exportaci\u00f3n");
            }
            if (periodo.isAnexoEnPeriodoDesdeMayo2016()) {
                return this.validarObjetosFiscalidad(periodo, resultado);
            }
        }
        return resultado.pasarValidacion();
    }

    private ResultadoValidacion validarObjetosFiscalidad(Periodo periodo, ResultadoValidacion resultado) {
        if (this.tipoRegimenFiscalExterior != null && periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            if ("01".equals(this.getTipoRegimenFiscalExterior())) {
                if (StringUtil.isNullOrEmpty((String)this.getPaisRegimenGeneral())) {
                    return resultado.fallarValidacion("Debe seleccionar el Pa\u00eds a qui\u00e9n se efect\u00faa el pago R\u00e9gimen General");
                }
                if (StringUtil.isNullOrEmpty((String)this.getPaisRegimenGeneral()) && StringUtil.isNullOrEmpty((String)this.getPaisPago())) {
                    return resultado.fallarValidacion(SELECCIONAR_PAIS_PAGO);
                }
                if (!StringUtil.isNullOrEmpty((String)this.getPaisRegimenGeneral()) && StringUtil.isNullOrEmpty((String)this.getPaisPago())) {
                    return resultado.fallarValidacion(SELECCIONAR_PAIS_PAGO);
                }
            }
            if ("02".equals(this.getTipoRegimenFiscalExterior())) {
                if (StringUtil.isNullOrEmpty((String)this.getPaisParaisoFiscal())) {
                    return resultado.fallarValidacion("Debe seleccionar el Pa\u00eds a qui\u00e9n se efect\u00faa el pago Para\u00edso Fiscal");
                }
                if (StringUtil.isNullOrEmpty((String)this.getPaisParaisoFiscal()) && StringUtil.isNullOrEmpty((String)this.getPaisPago())) {
                    return resultado.fallarValidacion("Debe seleccionar el Pa\u00eds a qui\u00e9n se efect\u00faa el pago Para\u00edso Fiscal");
                }
            }
            if (C_TIPO_REGIMEN_EXTERIOR_DENOMINACION.equals(this.getTipoRegimenFiscalExterior())) {
                if (StringUtil.isNullOrEmpty((String)this.getDenominacionRegimen())) {
                    return resultado.fallarValidacion("Debe ingresar Denominaci\u00f3n del r\u00e9gimen fiscal preferente o jurisdicci\u00f3n de menor imposici\u00f3n");
                }
                if (this.validarPattern("^[A-Z0-9]{1}[A-Z0-9\\s]{1,499}$", this.getDenominacionRegimen(), "El valor Denominaci\u00f3n del r\u00e9gimen fiscal preferente o jurisdicci\u00f3n de menor imposici\u00f3n debe cumplir  M\u00ednimo 2 caracteres, m\u00e1ximo 500. ", resultado).esEstadoFallido()) {
                    return resultado;
                }
            }
            if (StringUtil.isNullOrEmpty((String)this.getPaisPago()) && ("01".equals(this.getTipoRegimenFiscalExterior()) || "02".equals(this.getTipoRegimenFiscalExterior()))) {
                return resultado.fallarValidacion(SELECCIONAR_PAIS_PAGO);
            }
        } else if (StringUtil.isNullOrEmpty((String)this.getPaisPago())) {
            return resultado.fallarValidacion(SELECCIONAR_PAIS_PAGO);
        }
        return resultado;
    }

    protected ResultadoValidacion validarPattern(String regex, String value, String msg, ResultadoValidacion resultado) {
        if (!Pattern.matches(regex, value)) {
            return resultado.fallarValidacion(msg);
        }
        return resultado;
    }

    public FiscalidadInternacional crearCopiaEdicion() {
        FiscalidadInternacional copia = new FiscalidadInternacional();
        copia.setTipoPago(this.tipoPago);
        copia.setDescripcionTipoPago(this.descripcionTipoPago);
        copia.setTipoRegimenFiscalExterior(this.tipoRegimenFiscalExterior);
        copia.setDescripcionTipoRegimenFiscalExterior(this.descripcionTipoRegimenFiscalExterior);
        copia.setPaisRegimenGeneral(this.paisRegimenGeneral);
        copia.setDescripcionPaisRegimenGeneral(this.descripcionPaisRegimenGeneral);
        copia.setPaisParaisoFiscal(this.paisParaisoFiscal);
        copia.setDescripcionPaisParaisoFiscal(this.descripcionPaisParaisoFiscal);
        copia.setDenominacionRegimen(this.denominacionRegimen);
        copia.setPaisPago(this.paisPago);
        copia.setDescripcionPaisPago(this.descripcionPaisPago);
        copia.setPropietario((ObjetoModelo)((PagoLocalExterior)this.propietario));
        return copia;
    }

    public void actualizarInformacion(FiscalidadInternacional copiaEdicion) {
        this.setTipoPago(copiaEdicion.getTipoPago());
        this.setDescripcionTipoPago(copiaEdicion.getDescripcionTipoPago());
        this.setTipoRegimenFiscalExterior(copiaEdicion.getTipoRegimenFiscalExterior());
        this.setDescripcionTipoRegimenFiscalExterior(copiaEdicion.getDescripcionTipoRegimenFiscalExterior());
        this.setPaisRegimenGeneral(copiaEdicion.getPaisRegimenGeneral());
        this.setDescripcionPaisRegimenGeneral(copiaEdicion.getDescripcionPaisRegimenGeneral());
        this.setPaisParaisoFiscal(copiaEdicion.getPaisParaisoFiscal());
        this.setDescripcionPaisParaisoFiscal(copiaEdicion.getDescripcionPaisParaisoFiscal());
        this.setDenominacionRegimen(copiaEdicion.getDenominacionRegimen());
        this.setPaisPago(copiaEdicion.getPaisPago());
        this.setDescripcionPaisPago(copiaEdicion.getDescripcionPaisPago());
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        Iva iva = (Iva)this.getRaizModelo();
        Periodo periodo = iva.periodo;
        ModeloValoresPagoLocal modeloValores = new ModeloValoresPagoLocal(periodo.getFechaDeclarada());
        modeloValores.inicializaPeriodo(periodo);
        modeloValores.inicializar();
        NodeList valorList = elemento.getElementsByTagName("pagoLocExt");
        Element eValor = (Element)valorList.item(0);
        this.tipoPago = eValor.getTextContent().trim();
        this.descripcionTipoPago = modeloValores.obtenerTipoPago(this.getTipoPago()).getEtiqueta();
        if (!"01".equals(this.getTipoPago())) {
            this.importarFiscalidad(elemento);
        }
        return this;
    }

    public Object importarEnExportacion(Element elemento, Map<String, Element> mapaData) {
        this.importarFiscalidad(elemento);
        return this;
    }

    private void importarFiscalidad(Element elemento) {
        Iva iva = (Iva)this.getRaizModelo();
        Periodo periodo = iva.periodo;
        ModeloValoresPagoLocal modeloValores = new ModeloValoresPagoLocal(periodo.getFechaDeclarada());
        modeloValores.inicializaPeriodo(periodo);
        modeloValores.inicializar();
        NodeList valorList = elemento.getElementsByTagName("tipoRegi");
        Element eValor = (Element)valorList.item(0);
        if (eValor != null) {
            this.tipoRegimenFiscalExterior = eValor.getTextContent().trim();
            this.descripcionTipoRegimenFiscalExterior = modeloValores.obtenerTipoRegimenFicalDelExterior(this.getTipoRegimenFiscalExterior()).getEtiqueta();
        }
        if ((eValor = (Element)(valorList = elemento.getElementsByTagName("paisEfecPagoGen")).item(0)) != null) {
            this.paisRegimenGeneral = eValor.getTextContent().trim();
            this.descripcionPaisRegimenGeneral = modeloValores.obtenerPaisRegimenGeneral(this.getPaisRegimenGeneral()).getEtiqueta();
        }
        if ((eValor = (Element)(valorList = elemento.getElementsByTagName("paisEfecPagoParFis")).item(0)) != null) {
            this.paisParaisoFiscal = eValor.getTextContent().trim();
        }
        if ((eValor = (Element)(valorList = elemento.getElementsByTagName("denopagoRegFis")).item(0)) != null) {
            this.denominacionRegimen = eValor.getTextContent().trim();
        }
        if ((eValor = (Element)(valorList = elemento.getElementsByTagName("paisEfecPago")).item(0)) != null) {
            this.paisPago = eValor.getTextContent().trim();
            this.descripcionPaisPago = modeloValores.obtenerPais(this.getPaisPago()).getEtiqueta();
        }
    }

    public Element exportar(Document documento, Element elemento) {
        Element elmPgExt = documento.createElement("pagoExterior");
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        Element em = documento.createElement("pagoLocExt");
        em.setTextContent(this.getTipoPago());
        elmPgExt.appendChild(em);
        if (periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            em = documento.createElement("tipoRegi");
            em.setTextContent(this.getTipoRegimenFiscalExterior());
            elmPgExt.appendChild(em);
            em = documento.createElement("paisEfecPagoGen");
            em.setTextContent(this.getPaisRegimenGeneral());
            elmPgExt.appendChild(em);
            em = documento.createElement("paisEfecPagoParFis");
            em.setTextContent(this.getPaisParaisoFiscal());
            elmPgExt.appendChild(em);
            em = documento.createElement("denopagoRegFis");
            em.setTextContent(this.getDenominacionRegimen());
            elmPgExt.appendChild(em);
        }
        return elmPgExt;
    }

    public String getTipoPago() {
        return this.tipoPago;
    }

    public String getPaisPago() {
        return this.paisPago;
    }

    public String getDescripcionTipoPago() {
        return this.descripcionTipoPago;
    }

    public String getDescripcionPaisPago() {
        return this.descripcionPaisPago;
    }

    public String getTipoRegimenFiscalExterior() {
        return this.tipoRegimenFiscalExterior;
    }

    public String getDescripcionTipoRegimenFiscalExterior() {
        return this.descripcionTipoRegimenFiscalExterior;
    }

    public String getPaisRegimenGeneral() {
        return this.paisRegimenGeneral;
    }

    public String getDescripcionPaisRegimenGeneral() {
        return this.descripcionPaisRegimenGeneral;
    }

    public String getPaisParaisoFiscal() {
        return this.paisParaisoFiscal;
    }

    public String getDescripcionPaisParaisoFiscal() {
        return this.descripcionPaisParaisoFiscal;
    }

    public String getDenominacionRegimen() {
        return this.denominacionRegimen;
    }

    public void setTipoPago(String tipoPago) {
        String oldValue = this.tipoPago;
        this.tipoPago = StringUtil.isNullOrEmpty((String)tipoPago) ? tipoPago : tipoPago.toUpperCase();
        this.firePropertyChange(C_TIPO_PAGO, oldValue, this.tipoPago);
    }

    public void setDescripcionTipoPago(String descripcionTipoPago) {
        this.descripcionTipoPago = descripcionTipoPago;
    }

    public void setTipoRegimenFiscalExterior(String tipoRegimenFiscalExterior) {
        String oldValue = this.tipoRegimenFiscalExterior;
        this.tipoRegimenFiscalExterior = tipoRegimenFiscalExterior;
        this.firePropertyChange(C_TIPO_REGIMEN_FISCAL_EXTERIOR, oldValue, this.tipoRegimenFiscalExterior);
    }

    public void setDescripcionTipoRegimenFiscalExterior(String descripcionTipoRegimenFiscalExterior) {
        this.descripcionTipoRegimenFiscalExterior = descripcionTipoRegimenFiscalExterior;
    }

    public void setPaisPago(String paisPago) {
        String oldValue = this.paisPago;
        this.paisPago = StringUtil.isNullOrEmpty((String)paisPago) ? paisPago : paisPago.toUpperCase();
        this.firePropertyChange(C_PAIS_PAGO, oldValue, this.paisPago);
    }

    public void setDescripcionPaisPago(String descripcionPaisPago) {
        this.descripcionPaisPago = descripcionPaisPago;
    }

    public boolean isExportacion() {
        return this.exportacion;
    }

    public void setExportacion(boolean exportacion) {
        this.exportacion = exportacion;
    }

    public void setPaisRegimenGeneral(String paisRegimenGeneral) {
        String oldValue = this.paisRegimenGeneral;
        this.paisRegimenGeneral = StringUtil.isNullOrEmpty((String)paisRegimenGeneral) ? paisRegimenGeneral : paisRegimenGeneral.toUpperCase();
        this.firePropertyChange(C_PAIS_REGIMEN_GENERAL, oldValue, this.paisRegimenGeneral);
    }

    public void setDescripcionPaisRegimenGeneral(String descripcionPaisRegimenGeneral) {
        this.descripcionPaisRegimenGeneral = descripcionPaisRegimenGeneral;
    }

    public void setPaisParaisoFiscal(String paisParaisoFiscal) {
        String oldValue = this.paisParaisoFiscal;
        this.paisParaisoFiscal = StringUtil.isNullOrEmpty((String)paisParaisoFiscal) ? paisParaisoFiscal : paisParaisoFiscal.toUpperCase();
        this.firePropertyChange(C_PAIS_PARAISO_FISCAL, oldValue, this.paisParaisoFiscal);
    }

    public void setDescripcionPaisParaisoFiscal(String descripcionPaisParaisoFiscal) {
        this.descripcionPaisParaisoFiscal = descripcionPaisParaisoFiscal;
    }

    public void setDenominacionRegimen(String denominacionRegimen) {
        String oldValue = this.denominacionRegimen;
        this.denominacionRegimen = StringUtil.isNullOrEmpty((String)denominacionRegimen) ? denominacionRegimen : denominacionRegimen.toUpperCase();
        this.firePropertyChange(C_DENOMINACION_REGIMEN, oldValue, this.denominacionRegimen);
    }
}

